/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.setup;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.features.RFTFeature;
import mcjty.rftoolsdim.dimension.power.PowerHandler;
import mcjty.rftoolsdim.dimension.terraintypes.AttributeType;
import mcjty.rftoolsdim.dimension.terraintypes.RFToolsChunkGenerator;
import mcjty.rftoolsdim.modules.blob.entities.DimensionalBlobEntity;
import mcjty.rftoolsdim.modules.blob.tools.Spawner;
import mcjty.rftoolsdim.modules.dimlets.DimletConfig;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.network.PacketSendDimletPackages;
import mcjty.rftoolsdim.setup.RFToolsDimMessages;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class ForgeEventHandlers {
    private final Random random = new Random();
    private final PowerHandler powerHandler = new PowerHandler();
    private static int counter = 50;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomeLoad(BiomeLoadingEvent event) {
        event.getGeneration().getFeatures(GenerationStep.Decoration.RAW_GENERATION).add(RFTFeature.RFTFEATURE_CONFIGURED);
    }

    @SubscribeEvent
    public void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_7726_().m_8481_() instanceof RFToolsChunkGenerator && --counter < 0) {
            counter = 50;
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            if (stacktrace.length > 400) {
                RFToolsDim.setup.getLogger().warn("Canceled a possible stackoverflow: " + stacktrace.length);
                event.setCanceled(true);
                counter = 1;
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.world.f_46443_) {
            this.handleSpawning(event);
            if (event.world.m_46472_() == Level.f_46428_) {
                this.powerHandler.handlePower(event.world);
            }
        }
    }

    private void handleSpawning(TickEvent.WorldTickEvent event) {
        if (event.world.f_46443_) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)event.world;
        if (serverWorld.m_6907_().isEmpty()) {
            return;
        }
        ChunkGenerator chunkGenerator = serverWorld.m_7726_().m_8481_();
        if (chunkGenerator instanceof RFToolsChunkGenerator) {
            RFToolsChunkGenerator chunkGenerator2 = (RFToolsChunkGenerator)chunkGenerator;
            if (this.random.nextInt(20) == 10) {
                CompiledDescriptor compiledDescriptor = chunkGenerator2.getDimensionSettings().getCompiledDescriptor();
                DimensionData data = PersistantDimensionManager.get((Level)serverWorld).getData(serverWorld.m_46472_().m_135782_());
                if (!compiledDescriptor.getAttributeTypes().contains((Object)AttributeType.NOBLOBS)) {
                    int count = 0;
                    for (Entity entity : serverWorld.m_142646_().m_142273_()) {
                        if (!(entity instanceof DimensionalBlobEntity)) continue;
                        ++count;
                    }
                    if (count < 20) {
                        for (ServerPlayer player : serverWorld.m_6907_()) {
                            for (int i = 0; i < 5; ++i) {
                                Spawner.spawnOne(serverWorld, (Player)player, compiledDescriptor, data, this.random);
                            }
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        RFToolsDim.setup.getLogger().info("Reading dimlet packages: ");
        DimletDictionary.get().reset();
        for (String file : (List)DimletConfig.DIMLET_PACKAGES.get()) {
            DimletDictionary.get().readPackage(file);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        RFToolsDim.setup.getLogger().info("Client logged in: sending dimlet packages");
        HashMap<DimletKey, DimletSettings> collected = new HashMap<DimletKey, DimletSettings>();
        DimletDictionary dictionary = DimletDictionary.get();
        for (DimletKey key : dictionary.getDimlets()) {
            collected.put(key, dictionary.getSettings(key));
            if (collected.size() < 100) continue;
            RFToolsDimMessages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new PacketSendDimletPackages(collected));
            collected.clear();
        }
        if (!collected.isEmpty()) {
            RFToolsDimMessages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new PacketSendDimletPackages(collected));
        }
    }
}

